"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _classnames = _interopRequireDefault(require("classnames"));

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _atomTextEditor = require("./atom-text-editor");

var _marker = require("./marker");

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectSpread2(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const decorationPropTypes = {
  type: _propTypes.default.oneOf(['line', 'line-number', 'highlight', 'overlay', 'gutter', 'block']).isRequired,
  className: _propTypes.default.string,
  style: _propTypes.default.string,
  onlyHead: _propTypes.default.bool,
  onlyEmpty: _propTypes.default.bool,
  onlyNonEmpty: _propTypes.default.bool,
  omitEmptyLastRow: _propTypes.default.bool,
  position: _propTypes.default.oneOf(['head', 'tail', 'before', 'after']),
  order: _propTypes.default.number,
  avoidOverflow: _propTypes.default.bool,
  gutterName: _propTypes.default.string
};

class BareDecoration extends _react.default.Component {
  constructor(props, context) {
    super(props, context);

    _defineProperty(this, "observeParents", () => {
      this.decorationHolder.map(decoration => decoration.destroy());
      const editorValid = this.props.editorHolder.map(editor => !editor.isDestroyed()).getOr(false);
      const decorableValid = this.props.decorableHolder.map(decorable => !decorable.isDestroyed()).getOr(false); // Ensure the Marker or MarkerLayer corresponds to the context's TextEditor

      const decorableMatches = this.props.decorableHolder.map(decorable => this.props.editorHolder.map(editor => {
        const layer = decorable.layer || decorable;
        const displayLayer = editor.getMarkerLayer(layer.id);

        if (!displayLayer) {
          return false;
        }

        if (displayLayer !== layer && displayLayer.bufferMarkerLayer !== layer) {
          return false;
        }

        return true;
      }).getOr(false)).getOr(false);

      if (!editorValid || !decorableValid || !decorableMatches) {
        return;
      } // delay decoration creation when it's a gutter type;
      // instead wait for the Gutter to be added to the editor first


      if (this.props.type === 'gutter') {
        if (!this.props.gutterName) {
          throw new Error('You are trying to decorate a gutter but did not supply gutterName prop.');
        }

        this.props.editorHolder.map(editor => {
          this.gutterSub = editor.observeGutters(gutter => {
            if (gutter.name === this.props.gutterName) {
              this.createDecoration();
            }
          });
          return null;
        });
        return;
      }

      this.createDecoration();
    });

    this.decorationHolder = new _refHolder.default();
    this.editorSub = new _eventKit.Disposable();
    this.decorableSub = new _eventKit.Disposable();
    this.gutterSub = new _eventKit.Disposable();
    this.domNode = null;
    this.item = null;

    if (['gutter', 'overlay', 'block'].includes(this.props.type)) {
      this.domNode = document.createElement('div');
      this.domNode.className = (0, _classnames.default)('react-atom-decoration', this.props.className);
    }
  }

  usesItem() {
    return this.domNode !== null;
  }

  componentDidMount() {
    this.editorSub = this.props.editorHolder.observe(this.observeParents);
    this.decorableSub = this.props.decorableHolder.observe(this.observeParents);
  }

  componentDidUpdate(prevProps) {
    if (this.props.editorHolder !== prevProps.editorHolder) {
      this.editorSub.dispose();
      this.editorSub = this.props.editorHolder.observe(this.observeParents);
    }

    if (this.props.decorableHolder !== prevProps.decorableHolder) {
      this.decorableSub.dispose();
      this.decorableSub = this.props.decorableHolder.observe(this.observeParents);
    }

    if (Object.keys(decorationPropTypes).some(key => this.props[key] !== prevProps[key])) {
      this.decorationHolder.map(decoration => decoration.destroy());
      this.createDecoration();
    }
  }

  render() {
    if (this.usesItem()) {
      return _reactDom.default.createPortal(this.props.children, this.domNode);
    } else {
      return null;
    }
  }

  createDecoration() {
    if (this.usesItem() && !this.item) {
      this.item = (0, _helpers.createItem)(this.domNode, this.props.itemHolder);
    }

    const opts = this.getDecorationOpts(this.props);
    const editor = this.props.editorHolder.get();
    const decorable = this.props.decorableHolder.get();
    this.decorationHolder.setter(editor[this.props.decorateMethod](decorable, opts));
  }

  componentWillUnmount() {
    this.decorationHolder.map(decoration => decoration.destroy());
    this.editorSub.dispose();
    this.decorableSub.dispose();
    this.gutterSub.dispose();
  }

  getDecorationOpts(props) {
    return _objectSpread2({}, (0, _helpers.extractProps)(props, decorationPropTypes, {
      className: 'class'
    }), {
      item: this.item
    });
  }

}

_defineProperty(BareDecoration, "propTypes", _objectSpread2({
  editorHolder: _propTypes2.RefHolderPropType.isRequired,
  decorableHolder: _propTypes2.RefHolderPropType.isRequired,
  decorateMethod: _propTypes.default.oneOf(['decorateMarker', 'decorateMarkerLayer']),
  itemHolder: _propTypes2.RefHolderPropType,
  children: _propTypes.default.node
}, decorationPropTypes));

_defineProperty(BareDecoration, "defaultProps", {
  decorateMethod: 'decorateMarker'
});

class Decoration extends _react.default.Component {
  constructor(props) {
    super(props);
    this.state = {
      editorHolder: _refHolder.default.on(this.props.editor),
      decorableHolder: _refHolder.default.on(this.props.decorable)
    };
  }

  static getDerivedStateFromProps(props, state) {
    const editorChanged = state.editorHolder.map(editor => editor !== props.editor).getOr(props.editor !== undefined);
    const decorableChanged = state.decorableHolder.map(decorable => decorable !== props.decorable).getOr(props.decorable !== undefined);

    if (!editorChanged && !decorableChanged) {
      return null;
    }

    const nextState = {};

    if (editorChanged) {
      nextState.editorHolder = _refHolder.default.on(props.editor);
    }

    if (decorableChanged) {
      nextState.decorableHolder = _refHolder.default.on(props.decorable);
    }

    return nextState;
  }

  render() {
    return _react.default.createElement(_atomTextEditor.TextEditorContext.Consumer, null, editorHolder => _react.default.createElement(_marker.DecorableContext.Consumer, null, decorable => {
      let holder = null;
      let decorateMethod = null;

      if (!this.state.decorableHolder.isEmpty()) {
        holder = this.state.decorableHolder;
        decorateMethod = this.props.decorateMethod;
      } else {
        holder = decorable.holder;
        decorateMethod = decorable.decorateMethod;
      }

      return _react.default.createElement(BareDecoration, _extends({
        editorHolder: editorHolder || this.state.editorHolder,
        decorableHolder: holder,
        decorateMethod: decorateMethod
      }, this.props));
    }));
  }

}

exports.default = Decoration;

_defineProperty(Decoration, "propTypes", {
  editor: _propTypes.default.object,
  decorable: _propTypes.default.object,
  decorateMethod: _propTypes.default.oneOf(['decorateMarker', 'decorateMarkerLayer'])
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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