"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _atomTextEditor = require("./atom-text-editor");

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectSpread2(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const gutterProps = {
  name: _propTypes.default.string.isRequired,
  priority: _propTypes.default.number.isRequired,
  visible: _propTypes.default.bool,
  type: _propTypes.default.oneOf(['line-number', 'decorated']),
  labelFn: _propTypes.default.func,
  onMouseDown: _propTypes.default.func,
  onMouseMove: _propTypes.default.func
};

class BareGutter extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'observeEditor', 'forceUpdate');
    this.state = {
      gutter: null
    };
    this.sub = new _eventKit.Disposable();
  }

  componentDidMount() {
    this.sub = this.props.editorHolder.observe(this.observeEditor);
  }

  componentDidUpdate(prevProps) {
    if (this.props.editorHolder !== prevProps.editorHolder) {
      this.sub.dispose();
      this.sub = this.props.editorHolder.observe(this.observeEditor);
    }
  }

  componentWillUnmount() {
    if (this.state.gutter !== null) {
      try {
        this.state.gutter.destroy();
      } catch (e) {// Gutter already destroyed. Disregard.
      }
    }

    this.sub.dispose();
  }

  render() {
    return null;
  }

  observeEditor(editor) {
    this.setState((prevState, props) => {
      if (prevState.gutter !== null) {
        prevState.gutter.destroy();
      }

      const options = (0, _helpers.extractProps)(props, gutterProps);
      options.class = props.className;
      return {
        gutter: editor.addGutter(options)
      };
    });
  }

}

_defineProperty(BareGutter, "propTypes", _objectSpread2({
  editorHolder: _propTypes2.RefHolderPropType.isRequired,
  className: _propTypes.default.string
}, gutterProps));

_defineProperty(BareGutter, "defaultProps", {
  visible: true,
  type: 'decorated',
  labelFn: () => {}
});

class Gutter extends _react.default.Component {
  constructor(props) {
    super(props);
    this.state = {
      editorHolder: _refHolder.default.on(this.props.editor)
    };
  }

  static getDerivedStateFromProps(props, state) {
    const editorChanged = state.editorHolder.map(editor => editor !== props.editor).getOr(props.editor !== undefined);
    return editorChanged ? _refHolder.default.on(props.editor) : null;
  }

  render() {
    if (!this.state.editorHolder.isEmpty()) {
      return _react.default.createElement(BareGutter, _extends({}, this.props, {
        editorHolder: this.state.editorHolder
      }));
    }

    return _react.default.createElement(_atomTextEditor.TextEditorContext.Consumer, null, editorHolder => _react.default.createElement(BareGutter, _extends({}, this.props, {
      editorHolder: editorHolder
    })));
  }

}

exports.default = Gutter;

_defineProperty(Gutter, "propTypes", {
  editor: _propTypes.default.object
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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