"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _propTypes = _interopRequireDefault(require("prop-types"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class StatusBar extends _react.default.Component {
  constructor(props) {
    super(props);
    this.domNode = document.createElement('div');
    this.domNode.classList.add('react-atom-status-bar');

    if (props.className) {
      this.domNode.classList.add(props.className);
    }

    this.tile = null;
  }

  componentDidMount() {
    this.consumeStatusBar();
  }

  render() {
    return _reactDom.default.createPortal(this.props.children, this.domNode);
  }

  consumeStatusBar() {
    if (this.tile) {
      return;
    }

    if (!this.props.statusBar) {
      return;
    }

    this.tile = this.props.statusBar.addRightTile({
      item: this.domNode,
      priority: -50
    });
    this.props.onConsumeStatusBar(this.props.statusBar);
  }

  componentWillUnmount() {
    this.tile && this.tile.destroy();
  }

}

exports.default = StatusBar;

_defineProperty(StatusBar, "propTypes", {
  children: _propTypes.default.element.isRequired,
  statusBar: _propTypes.default.object,
  onConsumeStatusBar: _propTypes.default.func,
  className: _propTypes.default.string
});

_defineProperty(StatusBar, "defaultProps", {
  onConsumeStatusBar: statusBar => {}
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInN0YXR1cy1iYXIuanMiXSwibmFtZXMiOlsiU3RhdHVzQmFyIiwiUmVhY3QiLCJDb21wb25lbnQiLCJjb25zdHJ1Y3RvciIsInByb3BzIiwiZG9tTm9kZSIsImRvY3VtZW50IiwiY3JlYXRlRWxlbWVudCIsImNsYXNzTGlzdCIsImFkZCIsImNsYXNzTmFtZSIsInRpbGUiLCJjb21wb25lbnREaWRNb3VudCIsImNvbnN1bWVTdGF0dXNCYXIiLCJyZW5kZXIiLCJSZWFjdERPTSIsImNyZWF0ZVBvcnRhbCIsImNoaWxkcmVuIiwic3RhdHVzQmFyIiwiYWRkUmlnaHRUaWxlIiwiaXRlbSIsInByaW9yaXR5Iiwib25Db25zdW1lU3RhdHVzQmFyIiwiY29tcG9uZW50V2lsbFVubW91bnQiLCJkZXN0cm95IiwiUHJvcFR5cGVzIiwiZWxlbWVudCIsImlzUmVxdWlyZWQiLCJvYmplY3QiLCJmdW5jIiwic3RyaW5nIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBQUE7O0FBQ0E7O0FBQ0E7Ozs7OztBQUVlLE1BQU1BLFNBQU4sU0FBd0JDLGVBQU1DLFNBQTlCLENBQXdDO0FBWXJEQyxFQUFBQSxXQUFXLENBQUNDLEtBQUQsRUFBUTtBQUNqQixVQUFNQSxLQUFOO0FBRUEsU0FBS0MsT0FBTCxHQUFlQyxRQUFRLENBQUNDLGFBQVQsQ0FBdUIsS0FBdkIsQ0FBZjtBQUNBLFNBQUtGLE9BQUwsQ0FBYUcsU0FBYixDQUF1QkMsR0FBdkIsQ0FBMkIsdUJBQTNCOztBQUNBLFFBQUlMLEtBQUssQ0FBQ00sU0FBVixFQUFxQjtBQUNuQixXQUFLTCxPQUFMLENBQWFHLFNBQWIsQ0FBdUJDLEdBQXZCLENBQTJCTCxLQUFLLENBQUNNLFNBQWpDO0FBQ0Q7O0FBQ0QsU0FBS0MsSUFBTCxHQUFZLElBQVo7QUFDRDs7QUFFREMsRUFBQUEsaUJBQWlCLEdBQUc7QUFDbEIsU0FBS0MsZ0JBQUw7QUFDRDs7QUFFREMsRUFBQUEsTUFBTSxHQUFHO0FBQ1AsV0FBT0Msa0JBQVNDLFlBQVQsQ0FDTCxLQUFLWixLQUFMLENBQVdhLFFBRE4sRUFFTCxLQUFLWixPQUZBLENBQVA7QUFJRDs7QUFFRFEsRUFBQUEsZ0JBQWdCLEdBQUc7QUFDakIsUUFBSSxLQUFLRixJQUFULEVBQWU7QUFBRTtBQUFTOztBQUMxQixRQUFJLENBQUMsS0FBS1AsS0FBTCxDQUFXYyxTQUFoQixFQUEyQjtBQUFFO0FBQVM7O0FBRXRDLFNBQUtQLElBQUwsR0FBWSxLQUFLUCxLQUFMLENBQVdjLFNBQVgsQ0FBcUJDLFlBQXJCLENBQWtDO0FBQUNDLE1BQUFBLElBQUksRUFBRSxLQUFLZixPQUFaO0FBQXFCZ0IsTUFBQUEsUUFBUSxFQUFFLENBQUM7QUFBaEMsS0FBbEMsQ0FBWjtBQUNBLFNBQUtqQixLQUFMLENBQVdrQixrQkFBWCxDQUE4QixLQUFLbEIsS0FBTCxDQUFXYyxTQUF6QztBQUNEOztBQUVESyxFQUFBQSxvQkFBb0IsR0FBRztBQUNyQixTQUFLWixJQUFMLElBQWEsS0FBS0EsSUFBTCxDQUFVYSxPQUFWLEVBQWI7QUFDRDs7QUE1Q29EOzs7O2dCQUFsQ3hCLFMsZUFDQTtBQUNqQmlCLEVBQUFBLFFBQVEsRUFBRVEsbUJBQVVDLE9BQVYsQ0FBa0JDLFVBRFg7QUFFakJULEVBQUFBLFNBQVMsRUFBRU8sbUJBQVVHLE1BRko7QUFHakJOLEVBQUFBLGtCQUFrQixFQUFFRyxtQkFBVUksSUFIYjtBQUlqQm5CLEVBQUFBLFNBQVMsRUFBRWUsbUJBQVVLO0FBSkosQzs7Z0JBREE5QixTLGtCQVFHO0FBQ3BCc0IsRUFBQUEsa0JBQWtCLEVBQUVKLFNBQVMsSUFBSSxDQUFFO0FBRGYsQyIsInNvdXJjZVJvb3QiOiJEOlxcYVxcMVxcc1xcb3V0XFxhcHBcXG5vZGVfbW9kdWxlc1xcZ2l0aHViIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0IGZyb20gJ3JlYWN0JztcbmltcG9ydCBSZWFjdERPTSBmcm9tICdyZWFjdC1kb20nO1xuaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJztcblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgU3RhdHVzQmFyIGV4dGVuZHMgUmVhY3QuQ29tcG9uZW50IHtcbiAgc3RhdGljIHByb3BUeXBlcyA9IHtcbiAgICBjaGlsZHJlbjogUHJvcFR5cGVzLmVsZW1lbnQuaXNSZXF1aXJlZCxcbiAgICBzdGF0dXNCYXI6IFByb3BUeXBlcy5vYmplY3QsXG4gICAgb25Db25zdW1lU3RhdHVzQmFyOiBQcm9wVHlwZXMuZnVuYyxcbiAgICBjbGFzc05hbWU6IFByb3BUeXBlcy5zdHJpbmcsXG4gIH1cblxuICBzdGF0aWMgZGVmYXVsdFByb3BzID0ge1xuICAgIG9uQ29uc3VtZVN0YXR1c0Jhcjogc3RhdHVzQmFyID0+IHt9LFxuICB9XG5cbiAgY29uc3RydWN0b3IocHJvcHMpIHtcbiAgICBzdXBlcihwcm9wcyk7XG5cbiAgICB0aGlzLmRvbU5vZGUgPSBkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKTtcbiAgICB0aGlzLmRvbU5vZGUuY2xhc3NMaXN0LmFkZCgncmVhY3QtYXRvbS1zdGF0dXMtYmFyJyk7XG4gICAgaWYgKHByb3BzLmNsYXNzTmFtZSkge1xuICAgICAgdGhpcy5kb21Ob2RlLmNsYXNzTGlzdC5hZGQocHJvcHMuY2xhc3NOYW1lKTtcbiAgICB9XG4gICAgdGhpcy50aWxlID0gbnVsbDtcbiAgfVxuXG4gIGNvbXBvbmVudERpZE1vdW50KCkge1xuICAgIHRoaXMuY29uc3VtZVN0YXR1c0JhcigpO1xuICB9XG5cbiAgcmVuZGVyKCkge1xuICAgIHJldHVybiBSZWFjdERPTS5jcmVhdGVQb3J0YWwoXG4gICAgICB0aGlzLnByb3BzLmNoaWxkcmVuLFxuICAgICAgdGhpcy5kb21Ob2RlLFxuICAgICk7XG4gIH1cblxuICBjb25zdW1lU3RhdHVzQmFyKCkge1xuICAgIGlmICh0aGlzLnRpbGUpIHsgcmV0dXJuOyB9XG4gICAgaWYgKCF0aGlzLnByb3BzLnN0YXR1c0JhcikgeyByZXR1cm47IH1cblxuICAgIHRoaXMudGlsZSA9IHRoaXMucHJvcHMuc3RhdHVzQmFyLmFkZFJpZ2h0VGlsZSh7aXRlbTogdGhpcy5kb21Ob2RlLCBwcmlvcml0eTogLTUwfSk7XG4gICAgdGhpcy5wcm9wcy5vbkNvbnN1bWVTdGF0dXNCYXIodGhpcy5wcm9wcy5zdGF0dXNCYXIpO1xuICB9XG5cbiAgY29tcG9uZW50V2lsbFVubW91bnQoKSB7XG4gICAgdGhpcy50aWxlICYmIHRoaXMudGlsZS5kZXN0cm95KCk7XG4gIH1cbn1cbiJdfQ==