"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _propTypes2 = require("../prop-types");

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const VERBATIM_OPTION_PROPS = ['title', 'html', 'placement', 'trigger', 'keyBindingCommand', 'keyBindingTarget'];
const OPTION_PROPS = [...VERBATIM_OPTION_PROPS, 'tooltips', 'className', 'showDelay', 'hideDelay'];

class Tooltip extends _react.default.Component {
  constructor(props, context) {
    super(props, context);
    this.refSub = new _eventKit.Disposable();
    this.tipSub = new _eventKit.Disposable();
    this.domNode = null;

    if (this.props.children !== undefined) {
      this.domNode = document.createElement('div');
      this.domNode.className = 'react-atom-tooltip';
    }

    this.lastTooltipProps = {};
  }

  componentDidMount() {
    this.setupTooltip();
  }

  render() {
    if (this.props.children !== undefined) {
      return _reactDom.default.createPortal(this.props.children, this.domNode);
    } else {
      return null;
    }
  }

  componentDidUpdate() {
    if (this.shouldRecreateTooltip()) {
      this.refSub.dispose();
      this.tipSub.dispose();
      this.setupTooltip();
    }
  }

  componentWillUnmount() {
    this.refSub.dispose();
    this.tipSub.dispose();
  }

  getTooltipProps() {
    const p = {};

    for (const key of OPTION_PROPS) {
      p[key] = this.props[key];
    }

    return p;
  }

  shouldRecreateTooltip() {
    return OPTION_PROPS.some(key => this.lastTooltipProps[key] !== this.props[key]);
  }

  setupTooltip() {
    this.lastTooltipProps = this.getTooltipProps();
    const options = {};
    VERBATIM_OPTION_PROPS.forEach(key => {
      if (this.props[key] !== undefined) {
        options[key] = this.props[key];
      }
    });

    if (this.props.className !== undefined) {
      options.class = this.props.className;
    }

    if (this.props.showDelay !== undefined || this.props.hideDelay !== undefined) {
      const delayDefaults = (this.props.trigger === 'hover' || this.props.trigger === undefined) && {
        show: 1000,
        hide: 100
      } || {
        show: 0,
        hide: 0
      };
      options.delay = {
        show: this.props.showDelay !== undefined ? this.props.showDelay : delayDefaults.show,
        hide: this.props.hideDelay !== undefined ? this.props.hideDelay : delayDefaults.hide
      };
    }

    if (this.props.children !== undefined) {
      options.item = (0, _helpers.createItem)(this.domNode, this.props.itemHolder);
    }

    this.refSub = this.props.target.observe(t => {
      this.tipSub.dispose();
      this.tipSub = this.props.manager.add(t, options);
      const h = this.props.tooltipHolder;

      if (h) {
        h.setter(this.tipSub);
      }
    });
  }

}

exports.default = Tooltip;

_defineProperty(Tooltip, "propTypes", {
  manager: _propTypes.default.object.isRequired,
  target: _propTypes2.RefHolderPropType.isRequired,
  title: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.func]),
  html: _propTypes.default.bool,
  className: _propTypes.default.string,
  placement: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.func]),
  trigger: _propTypes.default.oneOf(['hover', 'click', 'focus', 'manual']),
  showDelay: _propTypes.default.number,
  hideDelay: _propTypes.default.number,
  keyBindingCommand: _propTypes.default.string,
  keyBindingTarget: _propTypes.default.element,
  children: _propTypes.default.element,
  itemHolder: _propTypes2.RefHolderPropType,
  tooltipHolder: _propTypes2.RefHolderPropType
});

_defineProperty(Tooltip, "defaultProps", {
  getItemComponent: () => {}
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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